"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseMapDef = void 0;
const parseDef_1 = require("../parseDef.js");
const record_1 = require("./record.js");
function parseMapDef(def, refs) {
    if (refs.mapStrategy === 'record') {
        return (0, record_1.parseRecordDef)(def, refs);
    }
    const keys = (0, parseDef_1.parseDef)(def.keyType._def, {
        ...refs,
        currentPath: [...refs.currentPath, 'items', 'items', '0'],
    }) || {};
    const values = (0, parseDef_1.parseDef)(def.valueType._def, {
        ...refs,
        currentPath: [...refs.currentPath, 'items', 'items', '1'],
    }) || {};
    return {
        type: 'array',
        maxItems: 125,
        items: {
            type: 'array',
            items: [keys, values],
            minItems: 2,
            maxItems: 2,
        },
    };
}
exports.parseMapDef = parseMapDef;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/b5a41840a0ce29fe5a86b2fa07c26b07f92684d2/node_modules/openai/_vendor/zod-to-json-schema/parsers/map.js.map